/* ============ */
/* bincoef.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
#include <mconf.h>
/* ==================================================================== */
/* GetGCD - finds greatest common divisor by Euclid's algorithn		*/
/* ==================================================================== */
static	LDBL
GetGCD(LDBL  m, LDBL  n)
{
    LDBL  t;

    m = floorl(fabsl(m)), n = floorl(fabsl(n));

    if (m < n)
    {
	t = m; m = n; n = t;
    }

    while (n > 0)
    {
	t = fmodl(m, n);
	m = n, n = t;
    }

    return (m);
}
/* ==================================================================== */
/* BinCoef - Returns the binomial coefficient (n,m)			*/
/* ==================================================================== */
double
BinCoef(double n, double m)
{
    LDBL    RetVal;

    if (n < m)
    {
	mtherr("BinCoef(): n < m", DOMAIN);
	RetVal = 0.0;
    }
    else if (m == 0 || m == n)
    {
	RetVal = 1;
    }
    else if (m == 1 || n - m == 1)
    {
	RetVal = n;
    }
    else
    {
	long double Fac, Gcd, k, Term;
	RetVal = n;
	Fac = 1;
	Term = 1;
	for (k = n - m + 1;  k < n; ++k)
	{
	    RetVal *= k;
	    Fac *= ++Term;
	    Gcd = GetGCD(RetVal, Fac);
	    RetVal /= Gcd;
	    Fac /= Gcd;
	}

	if (Fac != 1)
	{
	    fprintf(stderr,"BinCoef(%.f,%.f): Algorithm Failed\n",
		n, m);
	}
    }

    P(printf("BinCoef(%2.f,%2.f) = %.16Le\n", n, m, RetVal));

    return ((double)RetVal);
}
